-- --------------------------------------------------------------------------
-- Copyright  2008 PlayFirst, Inc. All Rights Reserved.
--
-- This material is the confidential trade secret and proprietary
-- information of PlayFirst, Inc. It may not be reproduced, used, disclosed,
-- sold or transferred without the prior written consent of PlayFirst, Inc. 
-- All rights reserved.
-- --------------------------------------------------------------------------
require( "scripts/style.lua" )

TableInfoFont = {
  standardFont,
  18,
  AquaColor
};


function MakeText()
	local anonHS = IsEnabled(kHiscoreAnonymous);
	if anonHS then
		return Group
			{
						Text
				{
					font = TableInfoFont,
					name = "info",
					x=kCenter,y=150,w=400 ,h=270,
					flags = kHAlignCenter+ kVAlignTop,
					label = "privacy_anon"
				};
			};
	else
		return Group
			{
				Text
				{
					font = TableInfoFont,
					name = "info",
					x=kCenter,y=150,w=400 ,h=270,
					flags = kHAlignCenter+ kVAlignTop,
					label = "highscorecompleteinfo"
				};
			};
	end;

end;

MakeDialog
{
	Bitmap
	{ 
		image="images/ui/common/popup03",	
		x=kCenter,
		y=kCenter,

		MakeText();
--		Text
--		{
--			font = TableInfoFont,
--			name = "info",
--			x=kCenter,y=150,w=400 ,h=kMax,
--			flags = kHAlignCenter+ kVAlignTop,
--			label = "highscorecompleteinfo"
--		};
		SetStyle(FitnessButtonStyleTittleXLBlue),
		
		SBButton{
			x=kCenter,
			y=370,
			font = StandardButtonFont,
			name="hiscoreinfook",
			icon="assets/images/ui/buttons/icon/iconok",
			label="common.ok.label",
			type = kPush,
			close=true
		};
		
		Button
		{
			x=0,
			y=0,
			w=50,
			h=20,
			graphics={},
			name="privacypolicy",
			command = 
				function()
					LaunchPrivacyPolicy();
				end
		};
	}
}



